<?php 
    /**
    *
    * copyright (c) 2013-2025 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
    
    $data1MeseFa       = date("Y-m-d h:i:sa", strtotime("-1 Months"));
    $queryUtentiAttivi = "SELECT * FROM geec_utenti WHERE ultimoLogin > '$data1MeseFa'";
    $risUtentiAttivi   = $geecomDb->eseguiQueryLettura($queryUtentiAttivi);
    $utentiAttivi      = $risUtentiAttivi->num_rows;
    $numeroUtenti      = $geecomDb->contaRigheTabella("geec_utenti");
    $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecAd_statistiche",1);
    $numeroLogin       = $datiStatistiche["numeroLogin"];
    $loginOggi         = $datiStatistiche["loginOggi"];
    $datiUtilizzoPiattaforma = calcoloUtilizzoPiattaforma($numeroUtenti,$utentiAttivi);

    $dataOggi    = new DateTime();
    $dataInstallazione = new DateTime($datiStatistiche["dataInstallazione"]);
    $intervallo = $dataOggi->diff($dataInstallazione);
    $differenzaGiorni = $intervallo->format('%d');
    
    $queryUltimoUtente = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente' ORDER BY id LIMIT 1";
    $risUltimoUtente   = $geecomDb->eseguiQueryLettura($queryUltimoUtente);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Amministrazione di Geecom Admin - statistiche</title>
        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    
    <body>
        
        <header>  
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
        
        <main role="main" class="bg-light" id="main">
		<div id="dashboard" class="container-fluid py-4">
                    <div class="row">
                        <div class="col-sm-5 col-lg-4 col-xl-3">
				<div id="SEOgenerale" class="collapse show">
					<div class="card border-0 text-white bg-<?php echo $datiUtilizzoPiattaforma["classeBoxUtilizzo"]; ?> p-3 mb-2 seo small">
						<div class="d-flex justify-content-between">
							<div class="w-100">
								<h6 class="mb-1"><i class="<?php echo $analisiSito["icona"]; ?>"></i> La percentuale di utilizzo è del <strong><?php echo $datiUtilizzoPiattaforma["percentualeUtilizzo"]; ?> %</strong></h6>
								<span><?php echo $datiUtilizzoPiattaforma["fraseUtilizzo"]; ?> <i class="fas fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="La percentuale media di utilizzo delle aree riservate è 40%"></i></span>
							</div>
						</div>
					</div>
					<div class="mb-1"><i class="far fa-calendar-alt mr-2"></i> La piattaforma è attiva da <?php echo $differenzaGiorni ?> giorni</div>
					<?php 
						if($risUltimoUtente->num_rows>0) {
							$queryConteggioUtente  = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente'";
							$risConteggioUtente    = $geecomDb->eseguiQueryLettura($queryUltimoUtente);
							$mediaUtentiRegistrati = $differenzaGiorni/$risConteggioUtente->num_rows;
					?>
					<div class="mb-1"><i class="fas fa-exclamation-triangle text-warning mr-2"></i> Si è registrato in media <?php echo $mediaUtentiRegistrati ?> utente al giorno</div>
					<?php 
						}

						if($risUltimoUtente->num_rows>0) {
							$utente = $risUltimoUtente->fetch_assoc();
					?>
					<div class="mb-1"><i class="fas fa-exclamation-triangle text-warning mr-2"></i> L'ultimo utente si è registrato il <?php echo date("d/m/Y",strtotime($utente["dataCreazione"])) ?></div>
					<?php
						}
						else {
					?>
					<div class="mb-1"><i class="fas fa-exclamation-triangle text-warning mr-2"></i> Non si è ancora registrato nessun utente</div>
					<?php
						}
					?>
				</div>
                        </div>
                        
                        <!-- Colonna principale -->
                        <div class="col-sm-7 col-lg-8 col-xl-9" id="riepilogoStatistiche">
                            <div class="row mb-4">
                                <div class="col-xl-4">
                                    <div class="card border-0 mb-4 accordion">
                                        <div class="card-header collapsed" data-toggle="collapse" href="#interazioniSito">
                                            <a class="card-title">
                                                Statistiche utenti
                                            </a>
                                        </div>
                                        <div id="interazioniSito" class="collapse show">
                                            <div class="card-body">
                                                <div class="row">
                                                    <?php 
                                                        $dataUtentiInattivi  = date("Y-m-d", strtotime( '-30 days' ));
                                                        $numeroTotaleUtenti  = $geecomDb->contaRigheTabella("geec_utenti",array("ruolo"=>"utente"));
                                                        $queryUtentiInattivi = "SELECT * FROM geec_utenti WHERE ultimoLogin <'$dataUtentiInattivi'";
                                                        $risUtentiInattivi   = $geecomDb->eseguiQueryLettura($queryUtentiInattivi);
                                                        if($risUtentiInattivi->num_rows>0) {
                                                            $faccinaUtentiInattivi = "fas fa-smile";
                                                            $classeUtentiInattivi  = ($risUtentiInattivi->num_rows>2) ? "text-danger" : "text-warning";
                                                            $fraseUtentiInattivi   = "Ottimo!";
                                                            $numeroUtentiInattivi    = $risUtentiInattivi->num_rows;
                                                        }
                                                        else {
                                                            $faccinaUtentiInattivi = "fas fa-meh";
                                                            $classeUtentiInattivi  = "text-warning";
                                                            $fraseUtentiInattivi   = "Dobbiamo migliorare!";
                                                            $numeroUtentiInattivi  = 0;
                                                        }
                                                        stampaBoxStatistica("Utenti attivi",$classeUtentiInattivi,$faccinaUtentiInattivi,$numeroUtentiInattivi,$fraseUtentiInattivi,"gestioneUtenti.php?tipo=utente","mb-xl-5");

                                                        $querySegnalazioni  = "SELECT * FROM geecAd_comunicazioni AS c WHERE tipo LIKE 'segnalazione'";
                                                        $risSegnalazioni    = $geecomDb->eseguiQueryLettura($querySegnalazioni);
                                                        if($risSegnalazioni->num_rows==0) {
                                                            $faccinaSegnalazioni = "fas fa-meh";
                                                            $classeSegnalazioni  = "text-warning";
                                                            $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                                            $numeroSegnalazioni  = 0;
                                                        }
                                                        else {
                                                            $faccinaSegnalazioni = "fas fa-smile";
                                                            $classeSegnalazioni  = "text-success";
                                                            $fraseSegnalazioni   = "Ottimo!";
                                                            $numeroSegnalazioni  = $risSegnalazioni->num_rows>0;
                                                        }
                                                        stampaBoxStatistica("Segnalazioni degli utenti",$classeUtentiInattivi,$faccinaUtentiInattivi,$numeroSegnalazioni,$fraseUtentiInattivi,"gestioneComunicazioni.php?tipo=segnalazione","mb-xl-5");

                                                    ?>
                                                    <div class="col-lg-4 col-xl-12 mb-5 mb-lg-0 text-center">
                                                        <h6 class="text-warning"><i class="fas fa-meh"></i></h6>
                                                        <h6 class="text-warning"><strong>0</strong> Messaggi dai form </h6>
                                                        <p>Si può fare meglio!</p>
                                                        <a href="componenti/form/" class="btn btn-primary btn-block btn-sm text-white leggi-tutto mt-3">Dettagli</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="card border-0 mb-4 accordion">
                                        <div class="card-header collapsed" data-toggle="collapse" href="#SEOpagine">
                                            <a class="card-title">
                                                Statistiche Comunicazioni
                                            </a>
                                        </div>
                                        <div id="SEOpagine" class="collapse show">
                                            <div class="card-body">
                                                
                                                <div class="row">
                                                    <?php 
                                                        $numeroComunicazioniNonEfficaci         = $geecomDb->contaRigheTabella("geecAd_comunicazioni",array("efficacia"=>"bassa"));
                                                        $fraseComunicazioniNonEfficaci          = ($numeroComunicazioniNonEfficaci==0) ? "Ottimo!" : "Dobbiamo migliorare!";
                                                        $classeFaccinaComunicazioniNonEfficaci  = ($numeroComunicazioniNonEfficaci==0) ? "fas fa-smile" : "fas fa-meh";
                                                        $classeTestualeComunicazioniNonEfficaci = ($numeroComunicazioniNonEfficaci==0) ? "text-success" : "text-danger";
                                                        stampaBoxStatistica("Comunicazioni non efficaci",$classeTestualeComunicazioniNonEfficaci,$classeFaccinaComunicazioniNonEfficaci,$numeroComunicazioniNonEfficaci,$fraseComunicazioniNonEfficaci,"gestioneComunicazioni.php?tipo=comunicazione&efficacia=bassa","mb-xl-5");

                                                        $numeroComunicazioniMediamenteEfficaci         = $geecomDb->contaRigheTabella("geecAd_comunicazioni",array("efficacia"=>"discreta"));
                                                        $fraseComunicazioniMediamenteEfficaci          = ($numeroComunicazioniMediamenteEfficaci==0) ? "Ottimo!" : "Dobbiamo migliorare!";
                                                        $classeFaccinaComunicazioniMediamenteEfficaci  = ($numeroComunicazioniMediamenteEfficaci==0) ? "fas fa-smile" : "fas fa-meh";
                                                        $classeTestualeComunicazioniMediamenteEfficaci = ($numeroComunicazioniMediamenteEfficaci==0) ? "text-success" : "text-danger";
                                                        stampaBoxStatistica("Comunicazioni poco efficaci",$classeTestualeComunicazioniMediamenteEfficaci,$classeFaccinaComunicazioniMediamenteEfficaci,$numeroComunicazioniMediamenteEfficaci,$fraseComunicazioniMediamenteEfficaci,"gestioneComunicazioni.php?tipo=comunicazione&efficacia=discreta","mb-xl-5");

                                                        $numeroComunicazioniEfficaci         = $geecomDb->contaRigheTabella("geecAd_comunicazioni",array("efficacia"=>"ottima"));
                                                        $fraseComunicazioniEfficaci          = ($numeroComunicazioniEfficaci==0) ? "Dobbiamo migliorare!" : "Ottimo!";
                                                        $classeFaccinaComunicazioniEfficaci  = ($numeroComunicazioniEfficaci>0) ? "fas fa-smile" : "fas fa-meh";
                                                        $classeTestualeComunicazioniEfficaci = ($numeroComunicazioniEfficaci>0) ? "text-success" : "text-warning";
                                                        stampaBoxStatistica("Comunicazioni efficaci",$classeTestualeComunicazioniEfficaci,$classeFaccinaComunicazioniEfficaci,$numeroComunicazioniEfficaci,$fraseComunicazioniEfficaci,"gestioneComunicazioni.php?tipo=comunicazione&efficacia=buona");
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="card border-0 mb-4 accordion">
                                        <div class="card-header collapsed" data-toggle="collapse" href="#SEOarticoli">
                                            <a class="card-title">
                                                Statistiche Ticket
                                            </a>
                                        </div>
                                        
                                        <div id="SEOarticoli" class="collapse show">
                                            <div class="card-body">
                                                
                                                <div class="row">
                                                    <?php 
                                                        $numeroTotaleTicket     = $geecomDb->contaRigheTabella("geecAd_comunicazioni",array("tipo"=>"ticket"));
                                                        $queryTaskSenzaRisposta = "SELECT * FROM geecAd_comunicazioni AS c WHERE tipo LIKE 'ticket' AND (SELECT COUNT(*) FROM geecAd_risposteTicket WHERE idTicket=c.id)";
                                                        $risTaskSenzaRisposta   = $geecomDb->eseguiQueryLettura($queryTaskSenzaRisposta);
                                                        if($risTaskSenzaRisposta->num_rows>0) {
                                                            $faccinaTicketSenzaRisposta = "fas fa-meh";
                                                            $classeTicketSenzaRisposta  = ($risTaskSenzaRisposta->num_rows>2) ? "text-danger" : "text-warning";
                                                            $fraseTicketSenzaRisposta   = "Dobbiamo migliorare!";
                                                            $numeroTicketSenzaRisposta  = $risTaskSenzaRisposta->num_rows;
                                                        }
                                                        else {
                                                            $faccinaTicketSenzaRisposta = "fas fa-smile";
                                                            $classeTicketSenzaRisposta  = "text-success";
                                                            $fraseTicketSenzaRisposta   = "Ottimo!";
                                                            $numeroTicketSenzaRisposta  = 0;
                                                        }
                                                        stampaBoxStatistica("Ticket senza risposta",$classeTicketSenzaRisposta,$faccinaTicketSenzaRisposta,$numeroTicketSenzaRisposta,$fraseTicketSenzaRisposta,"gestioneComunicazioni.php?tipo=ticket&stato=aperto","mb-xl-5");


                                                        $queryTicketNonRisolti  = "SELECT * FROM geecAd_comunicazioni AS c WHERE tipo LIKE 'ticket' AND stato NOT LIKE 'chiuso'";
                                                        $risTicketNonRisolti    = $geecomDb->eseguiQueryLettura($queryTicketNonRisolti);
                                                        if($risTicketNonRisolti->num_rows>0) {
                                                            $faccinaTicketNonRisolti = "fas fa-meh";
                                                            $classeTicketNonRisolti  = ($risTicketNonRisolti->num_rows>2) ? "text-danger" : "text-warning";
                                                            $fraseTicketNonRisolti   = "Dobbiamo migliorare!";
                                                            $numeroTicketNonRisolti  = $risTicketNonRisolti->num_rows>0;
                                                        }
                                                        else {
                                                            $faccinaTicketNonRisolti = "fas fa-smile";
                                                            $classeTicketNonRisolti  = "text-success";
                                                            $fraseTicketNonRisolti   = "Ottimo!";
                                                            $numeroTicketNonRisolti  = 0;
                                                        }
                                                        stampaBoxStatistica("Ticket non risolti",$classeTicketNonRisolti,$faccinaTicketNonRisolti,$numeroTicketNonRisolti,$fraseTicketNonRisolti,"gestioneComunicazioni.php?tipo=ticket&stato=aperto","mb-xl-5");

                                                        $queryTicketRisolti  = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE 'ticket' AND stato LIKE 'chiuso'";
                                                        $risTicketRisolti    = $geecomDb->eseguiQueryLettura($queryTicketRisolti);
                                                        if($risTicketRisolti->num_rows == $numeroTotaleTicket) {
                                                            $faccinaTicketisolti = "fas fa-smile";
                                                            $classeTicketRisolti = "text-success";
                                                            $fraseTicketRisolti  = "Ottimo!";
                                                            $numeroTicketRisolti = $risTicketRisolti->num_rows>0;
                                                        }
                                                        else {
                                                            $faccinaTicketisolti = "fas fa-meh";
                                                            $classeTicketRisolti = ($risTicketRisolti->num_rows>2) ? "text-danger" : "text-warning";
                                                            $fraseTicketRisolti  = "Dobbiamo migliorare!";
                                                            $numeroTicketRisolti = 0;
                                                        }
                                                        stampaBoxStatistica("Ticket risolti",$classeTicketRisolti,$faccinaTicketisolti,$numeroTicketRisolti,$fraseTicketRisolti,"gestioneComunicazioni.php?tipo=ticket&stato=chiuso");
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>  
	  
        <script>
            /*
             * Replace all SVG images with inline SVG
             */
            jQuery('img.svg').each(function(){
                var $img = jQuery(this);
                var imgID = $img.attr('id');
                var imgClass = $img.attr('class');
                var imgURL = $img.attr('src');

                jQuery.get(imgURL, function(data) {
                        // Get the SVG tag, ignore the rest
                        var $svg = jQuery(data).find('svg');

                        // Add replaced image's ID to the new SVG
                        if(typeof imgID !== 'undefined') {
                                $svg = $svg.attr('id', imgID);
                        }
                        // Add replaced image's classes to the new SVG
                        if(typeof imgClass !== 'undefined') {
                                $svg = $svg.attr('class', imgClass+' replaced-svg');
                        }

                        // Remove any invalid XML tags as per http://validator.w3.org
                        $svg = $svg.removeAttr('xmlns:a');

                        // Check if the viewport is set, if the viewport is not set the SVG wont't scale.
                        if(!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                                $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
                        }

                        // Replace image with new SVG
                        $img.replaceWith($svg);

                }, 'xml');
            });
	  
        </script>
	  
  </body>
</html>

<?php

    function stampaBoxStatistica($titoloSezione,$classeTestuale,$classeFaccina,$numeroELementi,$frase,$link,$classeAggiuntivaDiv = "") {
        ?>
        <div class="col-lg-4 col-xl-12 mb-5 mb-lg-0 <?php echo $classeAggiuntivaDiv ?> text-center">
            <h6 class="<?php echo $classeTestuale ?>"> <i class="<?php echo $classeFaccina ?>"></i></h6>
            <h6 class="<?php echo $classeTestuale ?>"><strong><?php echo $numeroELementi ?></strong> <?php echo $titoloSezione ?></h6>
            <p><?php echo $frase ?></p>
            <a href="<?php echo $link ?>" class="btn btn-primary btn-block btn-sm text-white leggi-tutto mt-3">Dettagli</a>
        </div>
        <?php
    }
